// ==UserScript==
// @name         自动选择及样式
// @namespace    http://tampermonkey.net/
// @version      2024-10-22
// @description  自动选择及样式
// @author       Daniel Du
// @match;        https://vip.dedegpt.vip/list
// @icon;         https://www.google.com/s2/favicons?sz=64&domain=dedegpt.vip
// @grant        none
// ==/UserScript==
(function () {
	// 设置小手样式
	document.body.addEventListener("mouseover", function (event) {
		if (event.target.classList.contains("boxclass")) {
			event.target.style.cursor = "pointer";
		}
	});
	const autoSelectButton = document.createElement("button");
	autoSelectButton.id = "checkAndClickButton";
	autoSelectButton.innerText = "自动选择";
	// 创建一个按钮并添加到页面上
	Object.assign(autoSelectButton.style, {
		fontSize: "14px",
		width: "80px",
		height: "30px",
		cursor: "pointer",
		position: "absolute",
		bottom: "10px",
		right: "50%",
		left: "50%",
		marginLeft: "-40px",
		borderRadius: "10px",
		border: "2px solid gray",
		fontFamily: "'思源黑体 CN Medium', sans-serif",
		transition: "background-color 0.3s ease",
	});
	autoSelectButton.addEventListener("mouseover", function () {
		autoSelectButton.style.backgroundColor = "darkgray";
	});
	autoSelectButton.addEventListener("mouseout", function () {
		autoSelectButton.style.backgroundColor = "";
	});
	// 页面增加按钮
	// 获取位置
	document
		.querySelector("#app > div > div.n-card.n-card--bordered.notice > div")
		.appendChild(autoSelectButton);
	// newButton 添加点击事件监听器
	autoSelectButton.addEventListener("click", function () {
		// 遍历所有的 boxclass 元素
		document.querySelectorAll(".boxclass").forEach((element) => {
			// 如果元素的文本内容包含“保留”就跳过
			if (element.textContent.includes("保留")) {
				// 跳过包含“保留”的元素
			} else {
				const staus_div = element.querySelector(".arco-progress-steps");
				// 检测包含style="background-color: rgb(36, 212, 174);"的div有几个
				count = staus_div.querySelectorAll(
					'div[style="background-color: rgb(36, 212, 174);"]',
				).length;
				// 如果有4个就点击
				if (count === 4) {
					element.style.backgroundColor = "orange";
				}
			}
		});
	});
})();
